//
// (c) 2020 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.5

import wesual.Stage 1.0
import wesual.Ui     1.0

import wesual.data.Core 1.0

ContainerOption {
    id : navigationScheme

    property list<Document> documents

    readonly property var navigationController : resources[value]

    key          : "we.captivo.containerOption.NavigationScheme"
    defaultValue : 0

    resources : [
        PageNavigationController {
            documents : navigationScheme.documents
        },
        CarouselNavigationController {
            documents : navigationScheme.documents
        }
    ]

    Column {
        property ContainerOption containerOption

        spacing : 9

        UiLabel { text : qsTrId("1374a17f49be412d") }

        Column {
            spacing : 9

            UiRadioButtonGroup {
                id : buttonGroup

                activeButton : containerOption.value === 0
                               ? pageWise : elementWise
            }

            UiRadioButton {
                id : pageWise

                text      : qsTrId("9da5e2c09cfdf32a")
                bindable  : true
                group     : buttonGroup
                onClicked : containerOption.updateValue(0)
            }
            UiRadioButton {
                id : elementWise

                text     : qsTrId("c7b81199627496dd")
                bindable : true
                group    : buttonGroup
                onClicked : containerOption.updateValue(1)
            }
        }
    }
}
